﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Context" xmlns="http://purl.oclc.org/dsdl/schematron">
    <title>Validations for contexts that are applicable accross all of the SSCCT services.</title>

    <rule context="xbrli:xbrl/xbrli:context[not(@i:nil='true')]">
        <let name="thisContextId" value="@id" />
        <let name="thisIdentifier" value="xbrli:entity/xbrli:identifier"/>

        <!-- Rule ID: VR.SS.GEN.100001
          
            IF ABNALGORITHM (MessageReceiver:xbrli:identifier) = FALSE
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.CCT.000065" diagnostics="DVR.SS.CCT.000065"
            test="not(
                exists($RP.MessageReceiver.Context[generate-id() = generate-id(current())])
                and
                xbrli:entity/xbrli:identifier
                [
                    not(function:ValidateABN(.))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.100002
          
            IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.02.xx:MessageSender) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.100002" diagnostics="DVR.SS.GEN.100002"
            test="not(
                xbrli:entity/xbrli:segment/xbrldi:explicitMember
                [          
                    not(@i:nil='true') 
                    and (ends-with(@dimension, ':ReportPartyTypeDimension') 
                    or @dimension = 'ReportPartyTypeDimension')
                    and (ends-with(., ':MessageSender') 
                    or . = 'MessageSender')
                ]
                and
                xbrli:entity/xbrli:identifier
                [
                    not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.100003
          
            IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.02.xx:MessageReceiver) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.100003" diagnostics="DVR.SS.GEN.100003"
            test="not(
                xbrli:entity/xbrli:segment/xbrldi:explicitMember
                [          
                    not(@i:nil='true') 
                    and (ends-with(@dimension, ':ReportPartyTypeDimension') 
                    or @dimension = 'ReportPartyTypeDimension')
                    and (ends-with(., ':MessageReceiver') 
                    or . = 'MessageReceiver')
                ]
                and
                xbrli:entity/xbrli:identifier
                [
                    not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.100100
            
            IF (CONTEXT(Payee) <> NULL) AND (ABNALGORITHM(Payeer:entity.identifier.ABN) = FALSE)
               RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.100100" diagnostics="DVR.SS.GEN.100100"
            test="not(
                exists($RP.Payee.Context[generate-id() = generate-id(current())])
                and
                xbrli:entity/xbrli:identifier[
                    not(function:ValidateABN(.))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.200001
          
            IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.02.xx:Payer) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.200001" diagnostics="DVR.SS.GEN.200001"
            test="not(
                xbrli:entity/xbrli:segment/xbrldi:explicitMember
                [          
                    not(@i:nil='true') 
                    and (ends-with(@dimension, ':ReportPartyTypeDimension') 
                    or @dimension = 'ReportPartyTypeDimension')
                    and (ends-with(., ':Payer') 
                    or . = 'Payer')
                ]
                and
                xbrli:entity/xbrli:identifier
                [
                    not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.200002
          
            IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.02.xx:Payee) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.200002" diagnostics="DVR.SS.GEN.200002"
            test="not(
                xbrli:entity/xbrli:segment/xbrldi:explicitMember
                [          
                    not(@i:nil='true') 
                    and (ends-with(@dimension, ':ReportPartyTypeDimension') 
                    or @dimension = 'ReportPartyTypeDimension')
                    and (ends-with(., ':Payee') 
                    or . = 'Payee')
                ]
                and
                xbrli:entity/xbrli:identifier
                [
                    not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.200003
          
            IF (RprtPyType.xx.xx:ReportingPartyTypeDimension = RprtPyType.02.xx:Employer) AND (xbrli:identifier scheme <> http://www.abr.gov.au/abn)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.200003" diagnostics="DVR.SS.GEN.200003"
            test="not(
                xbrli:entity/xbrli:segment/xbrldi:explicitMember
                [          
                    not(@i:nil='true') 
                    and (ends-with(@dimension, ':ReportPartyTypeDimension') 
                    or @dimension = 'ReportPartyTypeDimension')
                    and (ends-with(., ':Employer') 
                    or . = 'Employer')
                ]
                and
                xbrli:entity/xbrli:identifier
                [
                    not(matches(@scheme, '^http://www.abr.gov.au/abn$'))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.200004
        
            IF (xbrli:identifier scheme = "http://www.ato.gov.au/tfn" and TFNALGORITHM(xbrli:identifier) = FALSE)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.200004" diagnostics="DVR.SS.GEN.200004"
            test="not(
                xbrli:entity/xbrli:identifier
                [                        
                    matches(@scheme, '^http://www.ato.gov.au/tfn$')
                    and
                    not(function:ValidateTFN(.))
                ]
            )" />

        <!-- Rule ID: VR.SS.GEN.200006
        
            IF (RP.SUPERFUNDMEMBER:xbrli:identifier scheme <> "http://www.ato.gov.au/tfn")
              and (RP.SUPERFUNDMEMBER:xbrli:identifier scheme <> "http://www.sbr.gov.au/id")
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
        <assert id="VR.SS.GEN.200006" diagnostics="DVR.SS.GEN.200006"
            test="not(
                exists($RP.SuperFundMember.Context[generate-id() = generate-id(current())])
                and
                xbrli:entity/xbrli:identifier
                [
                    not(matches(@scheme, '^http://www.ato.gov.au/tfn$')
                    or
                    matches(@scheme, '^http://www.sbr.gov.au/id$'))
                ]
            )" />
    </rule>

    <rule context="xbrli:xbrl">
        <!-- Rule ID: VR.SS.CCT.000001
        
            IF COUNT(RP.SENDER) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000001" diagnostics="DVR.SS.CCT.000001"
            test="not(
                not($RP.MessageSender.ContextId)
            )" />

        <!-- Rule ID: VR.SS.CCT.000002
        
            IF COUNT(RP.SENDER) > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000002" diagnostics="DVR.SS.CCT.000002"
            test="not(
                count($RP.MessageSender.ContextId) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CCT.000003
        
            IF COUNT(RP.RECEIVER) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000003" diagnostics="DVR.SS.CCT.000003"
            test="not(
                not($RP.MessageReceiver.ContextId)
            )" />

        <!-- Rule ID: VR.SS.CCT.000004
        
            IF COUNT(RP.RECEIVER) > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000004" diagnostics="DVR.SS.CCT.000004"
            test="not(
                count($RP.MessageReceiver.ContextId) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CCT.000005
        
            IF COUNT(RP.PAYER) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000005" diagnostics="DVR.SS.CCT.000005"
            test="not(
                not($RP.Payer.ContextId)
            )" />

        <!-- Rule ID: VR.SS.CCT.000006
        
            IF COUNT(RP.PAYER) > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000006" diagnostics="DVR.SS.CCT.000006"
            test="not(
                count($RP.Payer.ContextId) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CCT.000007
        
            IF COUNT(RP.PAYEE) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000007" diagnostics="DVR.SS.CCT.000007"
            test="not(
                not($RP.Payee.ContextId)
            )" />

        <!-- Rule ID: VR.SS.CCT.000008
        
            IF COUNT(RP.PAYEE) > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000008" diagnostics="DVR.SS.CCT.000008"
            test="not(
                count($RP.Payee.ContextId) &gt; 1
            )" />

        <!-- Rule ID: VR.SS.CCT.000009
        
            IF COUNT(RP.EMPLOYER) < 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000009" diagnostics="DVR.SS.CCT.000009"
            test="not(
                not($RP.Employer.ContextId)
            )" />

        <!-- Rule ID: VR.SS.CCT.000010
        
            IF COUNT(RP.SUPERFUNDMEMBER) < 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.CCT.000010" diagnostics="DVR.SS.CCT.000010"
            test="not(
                not($RP.SuperFundMember.ContextId)
            )" />
    </rule>

    <rule context="xbrldi:typedMember[not(@i:nil='true') and ends-with(@dimension,':SuperFundABNDimension')]/*">
        <!-- Rule ID: VR.SS.GEN.200008
            
            IF (ABNALGORITHM (SprFndAbn.02.00:SuperFundABNDimension:SprFndAbn.02.00:Identifiers.AustralianBusinessNumber.Identifier) = FALSE)
              RETURN VALIDATION MESSAGE
            END IF
        -->
        <assert id="VR.SS.GEN.200008" diagnostics="DVR.SS.GEN.200008"
            test="not(
                (
                  ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier') 
                  or 
                  name() = 'Identifiers.AustralianBusinessNumber.Identifier'
                )
                and
                not(function:ValidateABN(.))
            )"/>
    </rule>
</pattern>